<?php
include 'koneksi.php';

function getSimilarity($item1, $item2, $conn) {
    $sql = "SELECT a.rating AS r1, b.rating AS r2
            FROM rating a
            JOIN rating b ON a.user_id = b.user_id
            WHERE a.film = '$item1' AND b.film = '$item2' AND a.rating > 0 AND b.rating > 0";
    $res = $conn->query($sql);
    $sum_xy = $sum_x2 = $sum_y2 = 0;
    while ($row = $res->fetch_assoc()) {
        $x = $row['r1']; $y = $row['r2'];
        $sum_xy += $x * $y;
        $sum_x2 += $x * $x;
        $sum_y2 += $y * $y;
    }
    return $sum_x2 * $sum_y2 == 0 ? 0 : $sum_xy / (sqrt($sum_x2) * sqrt($sum_y2));
}

function predictRating($user, $target_item, $conn) {
    $sql = "SELECT DISTINCT film FROM rating WHERE film != '$target_item'";
    $res = $conn->query($sql);
    $numer = 0; $denom = 0;
    while ($row = $res->fetch_assoc()) {
        $item = $row['film'];
        $sim = getSimilarity($target_item, $item, $conn);
        $sql2 = "SELECT rating FROM rating WHERE user_id = '$user' AND film = '$item'";
        $rate = $conn->query($sql2)->fetch_assoc()['rating'] ?? 0;
        $numer += $sim * $rate;
        $denom += abs($sim);
    }
    return $denom == 0 ? 0 : round($numer / $denom, 2);
}

echo "Prediksi rating U6 ke Titanic (Item-Based): " . predictRating("U6", "Titanic", $conn);
?>