<?php
include 'koneksi.php';

function getUserSimilarity($u1, $u2, $conn) {
    $sql = "SELECT a.rating AS r1, b.rating AS r2
            FROM rating a JOIN rating b
            ON a.film = b.film
            WHERE a.user_id = '$u1' AND b.user_id = '$u2' AND a.rating > 0 AND b.rating > 0";
    $res = $conn->query($sql);
    $sum_xy = $sum_x2 = $sum_y2 = 0;
    while ($row = $res->fetch_assoc()) {
        $x = $row['r1']; $y = $row['r2'];
        $sum_xy += $x * $y;
        $sum_x2 += $x * $x;
        $sum_y2 += $y * $y;
    }
    return $sum_x2 * $sum_y2 == 0 ? 0 : $sum_xy / (sqrt($sum_x2) * sqrt($sum_y2));
}

function predictUserRating($user, $target_item, $conn) {
    $sql = "SELECT DISTINCT user_id FROM rating WHERE user_id != '$user'";
    $res = $conn->query($sql);
    $numer = 0; $denom = 0;
    while ($row = $res->fetch_assoc()) {
        $other = $row['user_id'];
        $sim = getUserSimilarity($user, $other, $conn);
        $sql2 = "SELECT rating FROM rating WHERE user_id = '$other' AND film = '$target_item'";
        $rate = $conn->query($sql2)->fetch_assoc()['rating'] ?? 0;
        $numer += $sim * $rate;
        $denom += abs($sim);
    }
    return $denom == 0 ? 0 : round($numer / $denom, 2);
}

echo "<div style='text-align:center; font-size:18px; margin-top:20px;'>";
echo "Prediksi rating U2 ke Matrix (User-Based): " . predictUserRating("U2", "Matrix", $conn);
?>